<?php

namespace App\Exports;

use App\Models\Branch;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

class BranchesExport implements FromCollection, WithHeadings, WithEvents
{
    protected $categories;

    public function __construct($categories)
    {
        $this->categories = $categories;
    }

    public function collection()
    {
        return $this->categories->map(function ($branch) {
            return [
                'Nombre' => $branch->name,
                'Dirección' => $branch->address,
                'Teléfono' => $branch->phone,
                'Estado' => $branch->status,
            ];
        });
    }

    public function headings(): array
    {
        return ['Nombre', 'Dirección', 'Teléfono', 'Estado'];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $event->sheet->appendRows([
                    ['Cantidad de registros', count($this->categories)]
                ], $event);
            },
        ];
    }
}
