<?php

namespace App\Exports;

use App\Models\Category;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

class ClientsExport implements FromCollection, WithHeadings, WithEvents
{
    protected $clients;

    public function __construct($clients)
    {
        $this->clients = $clients;
    }

    public function collection()
    {
        return $this->clients->map(function ($client) {
            return [
                'Dni/Ruc' => $client->identity_card,
                'Nombre' => $client->first_name .' '. $client->last_name .' '. $client->middle_name,
                'Celular' => $client->phone_number,
            ];
        });
    }

    public function headings(): array
    {
        return ['Dni/Ruc', 'Nombre', 'Celular'];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $event->sheet->appendRows([
                    ['Cantidad de registros', count($this->clients)]
                ], $event);
            },
        ];
    }
}
