<?php

namespace App\Exports;

use App\Models\Employee;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class EmployeesExport implements FromCollection, WithHeadings
{
    protected $employees;

    public function __construct($employees)
    {
        $this->employees = $employees;
    }

    public function collection()
    {
        return $this->employees->map(function ($employee) {
            return [
                'ID' => $employee->id,
                'Nombre' => $employee->first_name,
                'Apellido' => $employee->last_name,
                'Documento' => $employee->document_number,
                'Cargo' => $employee->position,
                'Sueldo' => $employee->salary,
                'Dirección' => $employee->address,
                'Teléfono' => $employee->phone,
                'Registrado por' => optional($employee->user)->email,
                'Fecha de creación' => $employee->created_at->format('d/m/Y H:i'),
            ];
        });
    }

    public function headings(): array
    {
        return [
            'ID',
            'Nombre',
            'Apellido',
            'Documento',
            'Cargo',
            'Sueldo',
            'Dirección',
            'Teléfono',
            'Registrado por',
            'Fecha de creación',
        ];
    }
}
