<?php

namespace App\Exports;

use App\Models\ProductCorrection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

class ProductCorrectionsExport implements FromCollection, WithHeadings, WithEvents
{
    protected $productCorrections;

    public function __construct($productCorrections)
    {
        $this->productCorrections = $productCorrections;
    }

    public function collection()
    {
        return $this->productCorrections->map(function ($productCorrection) {
            return [
                'Fecha'        => $productCorrection->created_at->format('d/m/Y'),
                'Proveedor'    => $productCorrection->supplier->name,
                'Estado'       => $productCorrection->status == 'received' ? 'Recibido' : 'Enviado',
                'Fecha acción' => $productCorrection->status == 'received' ?  date('d/m/Y', strtotime($productCorrection->received_date)) : $productCorrection->created_at->format('d/m/Y'),
                'Estado pago'  => $productCorrection->payment_status == 'paid' ? 'Pagado' : 'Pendiente',
                'Total'        => $productCorrection->price,
            ];
        });
    }

    public function headings(): array
    {
        return ['Fecha', 'Proveedor', 'Estado envío', 'Fecha acción', 'Estado pago', 'Total'];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $rowCount = count($this->productCorrections) + 2;
                $totalGeneral = $this->productCorrections->sum('price');

                $event->sheet->appendRows([
                    ['', '', '', '', 'Total:', $totalGeneral]
                ], $event);
            },
        ];
    }
}
