<?php

namespace App\Exports;

use App\Models\Purchase;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

class PurchasesExport implements FromCollection, WithHeadings, WithEvents
{
    protected $purchases;

    public function __construct($purchases)
    {
        $this->purchases = $purchases;
    }

    public function collection()
    {
        return $this->purchases->map(function ($purchase) {
            return [
                'Fecha'        => $purchase->created_at->format('d/m/Y'),
                'Proveedor'    => $purchase->supplier->name,
                'N° de factura'=> $purchase->invoice_number,
                'Estado'       => $purchase->status,
                'Fecha acción' => optional($purchase->completed_date)->format('d/m/Y'),
                'Adelanto'     => $purchase->advance_payment,
                'Saldo'        => $purchase->total_amount - $purchase->advance_payment,
                'Total'        => $purchase->total_amount,
            ];
        });
    }

    public function headings(): array
    {
        return ['Fecha', 'Proveedor', 'N° de factura', 'Estado', 'Fecha acción', 'Adelanto', 'Saldo', 'Total'];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $rowCount = count($this->purchases) + 2;

                $totalAdvancePayment = $this->purchases->sum('advance_payment');
                $totalBalance = $this->purchases->sum(function ($p) {
                    return $p->total_amount - $p->advance_payment;
                });
                $totalGeneral = $this->purchases->sum('total_amount');

                $event->sheet->appendRows([
                    ['', '', '', '', 'Totales:', $totalAdvancePayment, $totalBalance, $totalGeneral]
                ], $event);
            },
        ];
    }
}
