<?php

namespace App\Exports;

use App\Models\Role;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

class RolesExport implements FromCollection, WithHeadings, WithEvents
{
    protected $roles;

    public function __construct($roles)
    {
        $this->roles = $roles;
    }

    public function collection()
    {
        return $this->roles->map(function ($role) {
            return [
                'Nombre' => $role->name,
            ];
        });
    }

    public function headings(): array
    {
        return ['Nombre'];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $event->sheet->appendRows([
                    ['Cantidad de registros', count($this->roles)]
                ], $event);
            },
        ];
    }
}
