<?php

namespace App\Exports;

use App\Models\Purchase;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

class SalesExport implements FromCollection, WithHeadings, WithEvents
{
    protected $sales;

    public function __construct($sales)
    {
        $this->sales = $sales;
    }

    public function collection()
    {
        return $this->sales->map(function ($sale) {
            return [
                'N°' => $sale->id,
                'Fecha'        => $sale->created_at->format('d/m/Y'),
                'Cliente'    => $sale->customer->first_name .' '. $sale->customer->last_name .' '. $sale->customer->middle_name,
                'Estado pago' => $sale->status,
                'Fecha acción' => optional($sale->completed_date)->format('d/m/Y'),
                'Adelanto'     => $sale->advance_payment,
                'Saldo'        => $sale->total - $sale->advance_payment,
                'Total'        => $sale->total,
            ];
        });
    }

    public function headings(): array
    {
        return ['N°', 'Fecha', 'Cliente', 'Estado pago', 'Fecha acción', 'Adelanto', 'Saldo', 'Total'];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $rowCount = count($this->sales) + 2;

                $totalAdvancePayment = $this->sales->sum('advance_payment');
                $totalBalance = $this->sales->sum(function ($p) {
                    return $p->total - $p->advance_payment;
                });
                $totalGeneral = $this->sales->sum('total');

                $event->sheet->appendRows([
                    ['', '', '', '', 'Totales:', $totalAdvancePayment, $totalBalance, $totalGeneral]
                ], $event);
            },
        ];
    }
}
