<?php

namespace App\Exports;

use App\Models\Supplier;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

class SuppliersExport implements FromCollection, WithHeadings, WithEvents
{
    protected $suppliers;

    public function __construct($suppliers)
    {
        $this->suppliers = $suppliers;
    }

    public function collection()
    {
        return $this->suppliers->map(function ($supplier) {
            return [
                'RNC' => $supplier->ruc,
                'Razón Social' => $supplier->name,
                'Persona contacto' => $supplier->contact_person,
                'Celular' => $supplier->phone_number,
                'Dirección' => $supplier->address,
            ];
        });
    }

    public function headings(): array
    {
        return ['RUC', 'Razón Social', 'Persona contacto', 'Celular', 'Dirección'];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $event->sheet->appendRows([
                    ['Cantidad de registros', count($this->suppliers)]
                ], $event);
            },
        ];
    }
}
