<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

class UsersExport implements FromCollection, WithHeadings, WithEvents
{
    protected $users;

    public function __construct($users)
    {
        $this->users = $users;
    }

    public function collection()
    {
        return $this->users->map(function ($user) {
            return [
                'Nombre' => $user->name,
                'Correo electrónico' => $user->email,
                'Rol' => count($user->roles) > 0 ? $user->roles[0]->name : '',
            ];
        });
    }

    public function headings(): array
    {
        return ['Nombre', 'Correo electrónico', 'Rol'];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $event->sheet->appendRows([
                    ['Cantidad de registros', count($this->users)]
                ], $event);
            },
        ];
    }
}
