<?php

namespace App\Http\Controllers;

use App\Services\BranchProductStockService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Inertia\Inertia;

class BranchProductVariantController extends Controller
{
    protected $branchProductStockService;

    public function __construct(BranchProductStockService $branchProductStockService)
    {
        $this->branchProductStockService = $branchProductStockService;
    } 

    public function list(Request $request)
    {
        return $this->branchProductStockService->list($request);
    }

    public function listByProduct($productId)
    {
        return $this->branchProductStockService->listByProduct($productId);
    }
 
    public function updateStockSuperAdmin(Request $request, $id)
    {
        $branchProductStockService = $this->branchProductStockService->updateStock($id, $request->stock, $request->user_id);

        if ($branchProductStockService) {
            return response()->json(
                [
                    'message' => 'Stock actualizado correctamente.',
                    'branchProductStockService' => $branchProductStockService
                ], 201
            );
        }
        
        return response()->json(['message' => 'Not found'], 404);
    }
}
 