<?php

namespace App\Http\Controllers;

use App\Services\ColorService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Requests\{ CategoryRequest, UpdateCategoryRequest };
use Inertia\Inertia;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Exports\CategoriesExport;
use Maatwebsite\Excel\Facades\Excel;

class ColorController extends Controller
{
    protected $colorService;

    public function __construct(ColorService $colorService)
    {
        $this->colorService = $colorService;
    }

    /**
     * Api categories list and search categories.
     *
     * @return \Illuminate\Http\Response
     */
    public function list(Request $request)
    {
        return response()->json($this->colorService->getAll()); // Retorna todas las categorías sin paginación
    }
}
