<?php

namespace App\Http\Controllers;

use App\Services\CategoryService;
use Illuminate\Support\Facades\DB;
use App\Models\{ Client, Supplier, Sale, Purchase };

class DashboardController extends Controller
{
    public function getChartData()
    {
        $quantityClients = Client::get()->count();
        $quantitySuppliers = Supplier::get()->count();
        $totalSales = Sale::get()->sum("advance_payment");
        $totalPurchases = Purchase::get()->sum("advance_payment");

        $sales = DB::table('sales')
            ->selectRaw('MONTH(created_at) as mes, SUM(total) as total')
            ->groupByRaw('MONTH(created_at)')
            ->pluck('total', 'mes');

        $purchases = DB::table('purchases')
            ->selectRaw('MONTH(created_at) as mes, SUM(total_amount) as total')
            ->groupByRaw('MONTH(created_at)')
            ->pluck('total', 'mes');

        // Rellenar los 12 meses con 0 si no hay datos
        $salesMonthly = [];
        $purchasesMonthly = [];

        for ($i = 1; $i <= 12; $i++) {
            $salesMonthly[] = $sales[$i] ?? 0;
            $purchasesMonthly[] = $purchases[$i] ?? 0;
        }

        return response()->json([
            'quantityClients' => $quantityClients,
            'quantitySuppliers' => $quantitySuppliers,
            'totalSales' => $totalSales,
            'totalPurchases' => $totalPurchases,
            'sales' => $salesMonthly,
            'purchases' => $purchasesMonthly,
        ]);
    }
}
