<?php

namespace App\Http\Controllers;

use App\Services\FurnitureServiceService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Requests\{ FurnitureServiceRequest, UpdateFurnitureServiceRequest };
use Inertia\Inertia;

class FurnitureServiceController extends Controller
{
    protected $furnitureServiceService;

    public function __construct(FurnitureServiceService $furnitureServiceService)
    {
        $this->furnitureServiceService = $furnitureServiceService;
    }

    public function index()
    {
        $startDate = date('Y-m-01');
        $endDate = date('Y-m-t');

        return Inertia::render('Admin/FurnitureServices/Index', [
            'startDate' => $startDate,
            'endDate' => $endDate
        ]);
    }

    /**
     * Api furniture services list and search.
     */
    public function list(Request $request)
    {
        if ($request->query('all')) {
            return response()->json($this->furnitureServiceService->getAll());
        }

        return $this->furnitureServiceService->list($request);
    }

    public function create()
    {
        return Inertia::render('Admin/FurnitureServices/Form');
    }

    public function show($id): JsonResponse
    {
        $service = $this->furnitureServiceService->getById($id);
        return $service
            ? response()->json($service)
            : response()->json(['message' => 'Not found'], 404);
    }

    public function store(FurnitureServiceRequest $request): JsonResponse
    {
        return response()->json(
            [
                'message' => 'Servicio de amoblado registrado correctamente.',
                'furniture_service' => $this->furnitureServiceService->create($request->validated())
            ],
            201
        );
    }

    public function edit($id)
    {
        $service = $this->furnitureServiceService->getById($id);

        return Inertia::render('Admin/FurnitureServices/Form', [
            'furniture_service' => $service
        ]);
    }

    public function update(UpdateFurnitureServiceRequest $request, $id): JsonResponse
    {
        $service = $this->furnitureServiceService->update($id, $request->validated());

        if ($service) {
            return response()->json(
                [
                    'message' => 'Servicio de amoblado actualizado correctamente.',
                    'furniture_service' => $service
                ],
                201
            );
        }

        return response()->json(['message' => 'Not found'], 404);
    }

    public function destroy($id): JsonResponse
    {
        return $this->furnitureServiceService->delete($id)
            ? response()->json(['message' => 'Servicio de amoblado eliminado correctamente.'])
            : response()->json(['message' => 'Not found'], 404);
    }
}
