<?php

namespace App\Http\Controllers;

use App\Http\Requests\MedicalConsultationRequest;
use App\Models\MedicalConsultation;
use App\Services\{ MedicalConsultationService, ClientService };
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Barryvdh\DomPDF\Facade\Pdf;

class MedicalConsultationController extends Controller
{
    protected $medicalConsultationService;
    protected $clientService;

    public function __construct(MedicalConsultationService $medicalConsultationService, ClientService $clientService)
    {
        $this->medicalConsultationService = $medicalConsultationService;
        $this->clientService = $clientService;
    }

    public function index($clientId)
    {
        return Inertia::render('Admin/MedicalConsultations/Index', [
            'clientId' => $clientId,
            'client' => $this->clientService->getById($clientId)
        ]);
    }
    
    /**
     * Api categories list and search products.
     *
     * @return \Illuminate\Http\Response
     */
    public function list(Request $request)
    {
        return $this->medicalConsultationService->list($request);
    }

    public function create($clientId)
    {
        return Inertia::render('Admin/MedicalConsultations/Form', [
            'client' => $this->clientService->getById($clientId)
        ]);
    }

    public function store(MedicalConsultationRequest $request): JsonResponse
    {
        $sale = $this->medicalConsultationService->create($request->validated());
        return response()->json(['message' => 'Consulta médica registrada correctamente', 'sale' => $sale], 201);
    }

    public function show(Sale $sale): JsonResponse
    {
        $sale->load('customer', 'saleDetails.product');
        return response()->json($sale);
    }

    public function destroy($id): JsonResponse
    {
        return $this->medicalConsultationService->delete($id)
            ? response()->json(['message' => 'Consulta médica cancelada correctamente.'])
            : response()->json(['message' => 'Not found'], 404);
    }

    public function exportPDF(Request $request, $clientId)
    {
        $client = $this->clientService->getById($clientId);
        $medicalConsultations = $this->medicalConsultationService->list($request);
        $pdf = Pdf::loadView('pdf.medical-consultations', ['client' => $client, 'medicalConsultations' => $medicalConsultations]);
        return $pdf->stream('medical-consultations.pdf');
    }
}
