<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;
use App\Services\RoleService;

use Auth;

class PermissionController extends Controller
{
    private $permissions = [
        'role-list',
        'role-create',
        'role-edit',
        'role-delete',

        'user-list',
        'user-create',
        'user-edit',
        'user-delete',

        'branch-list',
        'branch-create',
        'branch-edit',
        'branch-delete',

        'color-list',
        'color-create',
        'color-edit',
        'color-delete',

        'category-list',
        'category-create',
        'category-edit',
        'category-delete',

        'product-list',
        'product-create',
        'product-edit',
        'product-delete',

        'product-variant',
        'product-variant-create',
        'product-variant-edit',
        'product-variant-delete',
        
        'client-list',
        'client-create',
        'client-edit',
        'client-delete',

        'supplier-list',
        'supplier-create',
        'supplier-edit',
        'supplier-delete',

        'employee-list',
        'employee-create',
        'employee-edit',
        'employee-delete',

        'purchase-list',
        'purchase-create',
        'purchase-edit',
        'purchase-delete',
        'purchase-view',
        'purchase-payment',

        'sale-list',
        'sale-create',
        'sale-edit',
        'sale-delete',
        'sale-view',
        'sale-payment',
        'sale-print',

        'product-transfer-list',
        'product-transfer-create',
        'product-transfer-edit',
        'product-transfer-delete',
        'product-transfer-view',
        'product-transfer-payment',
        'product-transfer-print',

        'proforma-list',
        'proforma-create',
        'proforma-edit',
        'proforma-view',
        'proforma-go-on-sale',
        'proforma-cancel',

        'furnishing-services-list',
        'furnishing-services-create',
        'furnishing-services-edit',
        'furnishing-services-delete',
        'furnishing-services-view',
        'furnishing-services-payment',
        
        'cash-register-list',
        'cash-register-open',
        'cash-register-close',

        'furniture-service-list',
        'furniture-service-create',
        'furniture-service-edit',
        'furniture-service-delete',
        'furniture-service-view',
        'furniture-service-payment',
        'furniture-service-print',

        'staff-payments-list',
        'staff-payments-create',
        'staff-payments-cancel',
    ];

    protected $roleService;

    public function __construct(RoleService $roleService)
    {
        $this->roleService = $roleService;
    }

    public function index(): void
    {
        foreach ($this->permissions as $permission) {
            if(!Permission::where("name", $permission)->first())
                Permission::create(['name' => $permission]);
        }

        $role = $this->roleService->getByName('SUPER ADMIN');
        $role->syncPermissions([]);
        $allPermissions = Permission::all();
        $role->syncPermissions($allPermissions);

        echo "permisos actualizados";
    }

    public function getPermissionUser()
    {
        $user = Auth::user();
        
        return response()->json([
            'user' => $user,
            'permissions' => $user->getAllPermissions()->pluck('name'),
            'roles' => $user->getRoleNames()
        ]);
    }
}
