<?php

namespace App\Http\Controllers;

use App\Http\Requests\{ ProductCorrectionRequest };
use App\Services\ProductCorrectionItemService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inertia\Inertia;

class ProductCorrectionItemController extends Controller
{
    protected $productCorrectionItemService;

    public function __construct(ProductCorrectionItemService $productCorrectionItemService)
    {
        $this->productCorrectionItemService = $productCorrectionItemService;
    }

    public function index()
    {
        return Inertia::render('Admin/ProductsCorrections/Index');
    }

    /**
     * Api categories list and search products.
     *
     * @return \Illuminate\Http\Response
     */
    public function list(Request $request)
    {
        if ($request->query('all')) {
            // Retorna todos los clientes sin paginación
            return response()->json($this->productCorrectionItemService->getAll()); 
        }

        return $this->productCorrectionItemService->list($request);
    }

    public function checkReceived($id): JsonResponse
    {
        return $this->productCorrectionItemService->checkReceived($id)
            ? response()->json(['message' => 'El producto fue marcado como recibido.'])
            : response()->json(['message' => 'Not found'], 404);
    }

    public function toSentList()
    {
        return $this->productCorrectionItemService->toSentList();
    }
}
