<?php

namespace App\Http\Controllers;

use App\Services\ProductTransferService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Requests\ProductTransferRequest;
use App\Http\Requests\UpdateProductTransferRequest;
use Inertia\Inertia;

class ProductTransferController extends Controller
{
    protected $productTransferService;

    public function __construct(ProductTransferService $productTransferService)
    {
        $this->productTransferService = $productTransferService;
    }

    public function index()
    {
        return Inertia::render('Admin/ProductTransfers/Index');
    }

    public function list(Request $request)
    {
        return $this->productTransferService->list($request); 
    }

    public function create()
    {
        return Inertia::render('Admin/ProductTransfers/Form');
    }

    public function store(ProductTransferRequest $request): JsonResponse
    {
        $transfer = $this->productTransferService->create($request->validated());
  
        return response()->json([
            'message' => 'Movimiento registrado correctamente.',
            'transfer' => $transfer
        ], 201);
    }

    public function edit($id)
    {
        $transfer = $this->productTransferService->getById($id);

        return Inertia::render('Admin/ProductTransfers/Form', [
            'transfer' => $transfer
        ]);
    }

    public function update(ProductTransferRequest $request, $id)
    {
        $transfer = $this->productTransferService->update($id, $request->validated());

        if (!$transfer) {
            return response()->json(['message' => 'Movimiento no encontrado'], 404);
        }

        return response()->json([
            'message' => 'Movimiento actualizado correctamente.',
            'transfer' => $transfer
        ]);
    }

    public function show($id)
    {
        $transfer = $this->productTransferService->getById($id);

        return Inertia::render('Admin/ProductTransfers/Form', [
            'transfer' => $transfer
        ]);
    }
    
    public function destroy($id): JsonResponse
    {
        return $this->productTransferService->delete($id)
            ? response()->json(['message' => 'Movimiento eliminado correctamente.'])
            : response()->json(['message' => 'No encontrado'], 404);
    }
}
