<?php

namespace App\Http\Controllers;

use App\Models\ProductVariant;
use App\Http\Requests\{ ProductVariantRequest, UpdateProductVariantRequest };
use App\Services\{ ProductService, ProductVariantService };
use Illuminate\Http\Request;
use Inertia\Inertia;

class ProductVariantController extends Controller
{
    protected $productService;
    protected $productoVariantService;

    public function __construct(ProductService $productService, ProductVariantService $productoVariantService)
    {
        $this->productoVariantService = $productoVariantService;
        $this->productService = $productService;
    }

    public function index($productId)
    {
        return Inertia::render('Admin/ProductVariants/Index', [
            'productId' => $productId,
            'product' => $this->productService->getById($productId)
        ]);
    }

    /**
     * Api categories list and search products.
     *
     * @return \Illuminate\Http\Response
     */
    public function list(Request $request)
    {
        if ($request->query('all')) {
            return response()->json($this->productoVariantService->getAll($request)); // Retorna todos los productos
        }

        return $this->productoVariantService->list($request);
    }

    public function create($productId)
    {
        return Inertia::render('Admin/ProductVariants/Form', [
            'product' => $this->productService->getById($productId)
        ]);
    }

    public function store(ProductVariantRequest $request)
    {
        return response()->json(
            [
                'message' => 'Variante registrada correctamente.',
                'productoVariant' => $this->productoVariantService->create($request->validated())
            ], 201
        );
    }

    public function edit($id)
    {
        $productoVariant = $this->productoVariantService->getById($id);

        return Inertia::render('Admin/ProductVariants/Form', [
            'productVariant' => $productoVariant,
            'product' => $this->productService->getById($productoVariant->product_id)
        ]);
    }
 
    public function update(UpdateProductVariantRequest $request, $id)
    {
        $productoVariant = $this->productoVariantService->update($id, $request->validated());

        if ($productoVariant) {
            return response()->json(
                [
                    'message' => 'Variante actualizada correctamente.',
                ], 201
            );
        }
        
        return response()->json(['message' => 'Not found'], 404);
    }

    public function destroy($productVariantId)
    {
        $this->productoVariantService->delete($productVariantId);
        return response()->json(['message' => 'Variante eliminada correctamente']);
    }
}

