<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProformaRequest;
use App\Services\{ ProformaService, CashRegisterService };
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Inertia\Inertia;
use Auth;

class ProformaController extends Controller
{
    protected $cashRegisterService;
    protected $proformaService;

    public function __construct(CashRegisterService $cashRegisterService, ProformaService $proformaService)
    {
        $this->cashRegisterService = $cashRegisterService;
        $this->proformaService = $proformaService;
    }

    public function index()
    {
        $startDate = date('Y-m-01');
        $endDate = date('Y-m-t');

        return Inertia::render('Admin/Proformas/Index', [
            'startDate' => $startDate,
            'endDate' => $endDate,
            'cashRegister' => $this->cashRegisterService->getByUserFirst(Auth::user()->id),
        ]);
    }

    public function list(Request $request)
    {
        return $this->proformaService->list($request);
    }

    public function create()
    {
        return Inertia::render('Admin/Proformas/Form');
    }

    public function show($id)
    {
        $proforma = $this->proformaService->getById($id);
        
        return Inertia::render('Admin/Proformas/Form', [
            'proforma' => $proforma
        ]);
    }

    public function store(ProformaRequest $request)
    {
        $proforma = $this->proformaService->create(
            $request->only('customer_id','user_id','status', 'total', 'has_furniture_service', 'delivery_date'),
            $request->items
        );

        return response()->json([
            'message' => 'Pedido registrada correctamente',
            'proforma' => $proforma
        ]);
    }

    public function edit($id)
    {
        $proforma = $this->proformaService->getById($id);

        return Inertia::render('Admin/Proformas/Form', [
            'proforma' => $proforma
        ]);
    }

    public function update(ProformaRequest $request, $id)
    {
        $proforma = $this->proformaService->update(
            $id,
            $request->only('customer_id','user_id','status', 'total', 'has_furniture_service', 'delivery_date'),
            $request->items
        );

        return response()->json([
            'message' => 'Pedido actualizado correctamente.',
            'proforma' => $proforma
        ]);
    }
 
    public function destroy($id)
    {
        return $this->proformaService->delete($id)
            ? response()->json(['message' => 'Pedido cancelada correctamente.'])
            : response()->json(['message' => 'Not found'], 404);
    }

    public function confirmOrder(Request $request, $id)
    {
        $proforma = $this->proformaService->confirmOrder($id, $request);

        return response()->json([
            'message' => 'Pedido confirmado correctamente.',
            'proforma' => $proforma
        ], 201);
    }

    public function convertToSale(Request $request, $id, $userId, $branchId, $cashRegisterId)
    {
        $proforma = $this->proformaService->convertToSale($request->items, $id, $userId, $branchId, $cashRegisterId);

        return response()->json([
            'message' => 'Pedido convertido en una venta correctamente.',
            'proforma' => $proforma
        ], 201);
    }

    public function deleteItem($itemId)
    {
        return $this->proformaService->deleteItem($itemId)
            ? response()->json(['message' => 'Pedido quitado correctamente.'])
            : response()->json(['message' => 'Not found'], 404);
    }

    public function exportPDFById($id)
    {
        $proforma = $this->proformaService->getById($id);

        $pdf = Pdf::loadView('pdf.proformas', 
                    [
                        'proforma' => $proforma,
                    ]);
        return $pdf->stream('proforma.pdf');
    }
}
