<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\PurchasePaymentRequest;
use App\Services\PurchasePaymentService;
use Illuminate\Http\JsonResponse;

class PurchasePaymentController extends Controller
{
    protected $purchasePaymentService;

    public function __construct(PurchasePaymentService $purchasePaymentService)
    {
        $this->purchasePaymentService = $purchasePaymentService;
    }

    /**
     * Api categories list and search products.
     *
     * @return \Illuminate\Http\Response
     */
    public function list($purchaseId)
    {
        return $this->purchasePaymentService->list($purchaseId);
    }

    public function store(PurchasePaymentRequest $request): JsonResponse
    {
        $purchasePayment = $this->purchasePaymentService->create($request->validated());

        if ($purchasePayment) {
            return response()->json(['message' => 'Pago registrado correctamente', 'purchasePayment' => $purchasePayment], 201);
        }
        else {
            return response()->json(['message' => 'El monto ingresado es es mayor al saldo. ', 'purchasePayment' => $purchasePayment], 201);
        }
    }
}
