<?php

namespace App\Http\Controllers;

use App\Http\Requests\SaleRequest;
use App\Services\SaleDetailService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inertia\Inertia;

class SaleDetailController extends Controller
{
    protected $saleDetailService;

    public function __construct(SaleDetailService $saleDetailService)
    {
        $this->saleDetailService = $saleDetailService;
    }

    public function list($saleId)
    {
        return $this->saleDetailService->list($saleId);
    }

    public function addToSupplier(Request $request): JsonResponse
    {
        $sale = $this->saleDetailService->addToSupplier($request);
        return response()->json(['message' => 'Productos para enviar al proveedor registrados correctamente.'], 201);
    }

    public function removeToSupplier($saleDetailId): JsonResponse
    {
        $sale = $this->saleDetailService->removeToSupplier($saleDetailId);
        return response()->json(['message' => 'El producto fue quitado para enviar.'], 201);
    }

    public function listToSend($supplierId)
    {
        return $this->saleDetailService->listToSend($supplierId);
    }
}
