<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\SalePaymentRequest;
use App\Services\{ CashRegisterService, SalePaymentService };
use Illuminate\Http\JsonResponse;

class SalePaymentController extends Controller
{
    protected $cashRegisterService;
    protected $salePaymentService;

    public function __construct(CashRegisterService $cashRegisterService, SalePaymentService $salePaymentService)
    {
        $this->cashRegisterService = $cashRegisterService;
        $this->salePaymentService = $salePaymentService;
    }

    /**
     * Api categories list and search products.
     *
     * @return \Illuminate\Http\Response
     */
    public function list($saleId)
    {
        return $this->salePaymentService->list($saleId);
    }

    public function store(SalePaymentRequest $request): JsonResponse
    {
        $cashRegister = $this->cashRegisterService->getByUserFirst($request->user_id);

        if ($cashRegister == null) {
            return response()->json(['message' => 'No tienes una caja abierta, por favor abre una caja.'], 400);
        }

        $salePayment = $this->salePaymentService->create($request->validated(), $cashRegister->id);

        if ($salePayment) {
            return response()->json(['message' => 'Pago registrado correctamente', 'salePayment' => $salePayment], 201);
        }
        else {
            return response()->json(['message' => 'El monto ingresado es es mayor al saldo. ', 'salePayment' => $salePayment], 201);
        }
    }
}
