<?php

namespace App\Http\Controllers;

use App\Services\sizeService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Requests\{ CategoryRequest, UpdateCategoryRequest };
use Inertia\Inertia;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Exports\CategoriesExport;
use Maatwebsite\Excel\Facades\Excel;

class SizeController extends Controller
{
    protected $sizeService;

    public function __construct(SizeService $sizeService)
    {
        $this->sizeService = $sizeService;
    }

    /**
     * Api categories list and search categories.
     *
     * @return \Illuminate\Http\Response
     */
    public function list(Request $request)
    {
        return response()->json($this->sizeService->getAll()); // Retorna todas las categorías sin paginación
    }
}
