<?php

namespace App\Http\Controllers;

use App\Services\StaffPaymentService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Requests\{ StaffPaymentRequest };
use Inertia\Inertia;
use Barryvdh\DomPDF\Facade\Pdf;

class StaffPaymentController extends Controller
{
    protected $staffPaymentService;

    public function __construct(StaffPaymentService $staffPaymentService)
    {
        $this->staffPaymentService = $staffPaymentService;
    }

    public function index()
    {
        $startDate = date('Y-m-01');
        $endDate = date('Y-m-t');

        return Inertia::render('Admin/StaffPayments/Index', [
            'startDate' => $startDate,
            'endDate' => $endDate
        ]);
    }

    /**
     * API lista de pagos y búsqueda
     */
    public function list(Request $request)
    {
        if ($request->query('all')) {
            return response()->json($this->staffPaymentService->getAll()); 
        }

        return $this->staffPaymentService->list($request);
    }

    public function create()
    {
        return Inertia::render('Admin/StaffPayments/Form');
    }

    public function show($id): JsonResponse
    {
        $payment = $this->staffPaymentService->getById($id);
        return $payment 
            ? response()->json($payment) 
            : response()->json(['message' => 'Not found'], 404);
    }

    public function store(StaffPaymentRequest $request): JsonResponse
    {
        return response()->json(
            [
                'message' => 'Pago registrado correctamente.',
                'payment' => $this->staffPaymentService->create($request->validated())
            ], 201
        );
    }

    public function edit($id)
    {
        $payment = $this->staffPaymentService->getById($id);

        return Inertia::render('Admin/StaffPayments/Form', [
            'payment' => $payment
        ]);
    }

    public function update(StaffPaymentRequest $request, $id): JsonResponse
    {
        $payment = $this->staffPaymentService->update($id, $request->validated());

        if ($payment) {
            return response()->json(
                [
                    'message' => 'Pago actualizado correctamente.',
                    'payment' => $payment
                ], 201
            );
        }
        
        return response()->json(['message' => 'Not found'], 404);
    }

    public function destroy($id): JsonResponse
    {
        return $this->staffPaymentService->delete($id)
            ? response()->json(['message' => 'Pago eliminado correctamente.'])
            : response()->json(['message' => 'Not found'], 404);
    }

    public function exportPDF(Request $request)
    {
        $staffPayments  = $this->staffPaymentService->list($request);
        $pdf = Pdf::loadView('pdf.staff_payments', ['staffPayments' => $staffPayments]);
        return $pdf->stream('staff_payments.pdf');
    }
}
