<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BrandRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'user_id' => "nullable|exists:users,id",
            'name' => 'required|string|unique:brands,name|min:2|max:50',
            'description' => 'nullable|string|max:150',
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'El nombre de la marca es obligatorio',
            'name.unique' => 'La marca ya existe',
            'name.min' => 'El nombre debe tener al menos 2 caracteres',
            'name.max' => 'El nombre debe tener máximo 50 caracteres',

            'description.max' => 'La descripción debe tener máximo 150 caracteres',
        ];
    }
}
