<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'user_id' => "nullable",
            'name' => 'required|string|unique:categories,name|min:5|max:50|',
            'description' => 'nullable|string|min:5|max:100|',
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'El campo es obligatorio',
            'name.unique' => 'El nombre ya existe',
            'name.min' => 'El nombre debe tener mínimo 5 dígitos',
            'name.max' => 'El nombre debe tener máximo 50 dígitos',

            'description.min' => 'La descripción debe tener mínimo 5 dígitos',
            'description.max' => 'La descripción debe tener máximo 100 dígitos',
        ];
    }
}
