<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ClientRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'user_id' => "nullable",
            'first_name' => 'required|string|min:4|max:40',
            'last_name' => 'required|string|min:4|max:40',
            'middle_name' => 'required|string|min:4|max:40',
            'identity_card' => 'required|string|min:8|max:12|unique:clients,identity_card,' . $this->client,
            'phone_number' => 'nullable|string|min:6|max:20',
        ];
    }

    public function messages(): array
    {
        return [
            'first_name.required' => 'El campo es obligatorio',
            'first_name.string' => 'Ingrese una cadena correcta',
            'first_name.min' => 'Ingrese mínimo 4 dígitos',
            'first_name.max' => 'Ingrese máximo 40 dígitos',

            'last_name.required' => 'El campo es obligatorio',
            'last_name.string' => 'Ingrese una cadena correcta',
            'last_name.min' => 'Ingrese mínimo 4 dígitos',
            'last_name.max' => 'Ingrese máximo 40 dígitos',

            'middle_name.required' => 'El campo es obligatorio',
            'middle_name.string' => 'Ingrese una cadena correcta',
            'middle_name.min' => 'Ingrese mínimo 4 dígitos',
            'middle_name.max' => 'Ingrese máximo 40 dígitos',

            'identity_card.required' => 'El campo es obligatorio',
            'identity_card.string' => 'Ingrese una cadena correcta',
            'identity_card.min' => 'Ingrese mínimo 8 dígitos',
            'identity_card.max' => 'Ingrese máximo 12 dígitos',
            'identity_card.unique' => 'El documento ya existe',

            'phone_number.string' => 'Ingrese una cadena correcta',
            'phone_number.min' => 'Ingrese mínimo 6 dígitos',
            'phone_number.max' => 'Ingrese máximo 20 dígitos',
        ];
    }
}

