<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CloseCashRegisterRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true; 
    }

    public function rules(): array
    {
        return [
            'closing_amount' => 'required|numeric|min:0',
        ];
    }

    public function messages(): array
    {
        return [
            'closing_amount.required' => 'Debe ingresar el monto de cierre.',
            'closing_amount.numeric' => 'El monto de cierre debe ser numérico.',
            'closing_amount.min' => 'El monto de cierre no puede ser negativo.',
        ];
    }
}
