<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EmployeeRequest extends FormRequest
{
    public function authorize(): bool
    {
        // Si manejas roles/permisos, aquí puedes validar
        return true;
    }

    public function rules(): array
    {
        return [
            'first_name'       => 'required|string|max:100',
            'last_name'        => 'required|string|max:100',
            'document_number'  => 'required|string|max:11|unique:employees,document_number',
            'position'         => 'required|string|max:100', // cargo/puesto
            'salary'           => 'required|numeric|min:0',
            'address'          => 'required|string|max:255',
            'phone'            => 'required|string|max:20',
            'user_id'          => 'required|exists:users,id',
        ];
    }

    public function messages(): array
    {
        return [ 
            'first_name.required'      => 'El nombre es obligatorio.',
            'first_name.max'      => 'Ingrese máximo 100 dígitos.',

            'last_name.required'       => 'El apellido es obligatorio.',
            'last_name.max'      => 'Ingrese máximo 100 dígitos.',

            'document_number.required' => 'El número de documento es obligatorio.',
            'document_number.unique'   => 'El número de documento ya está registrado.',
            'document_number.max'      => 'Ingrese máximo 11 dígitos.',

            'position.required' => 'El campo es obligatorio.',
            'position.max'      => 'Ingrese máximo 100 dígitos.',

            'salary.required' => 'El campo es obligatorio.',
            'salary.numeric'      => 'Ingrese un valor numérico.',
            'salary.min'      => 'Ingrese mínimo 0.',

            'address.required' => 'El campo es obligatorio.',
            'address.max'      => 'Ingrese máximo 255 dígitos.',

            'phone.required' => 'El campo es obligatorio.',
            'phone.max'      => 'Ingrese máximo 20 dígitos.',

            'user_id.required'         => 'El usuario es obligatorio.',
        ];
    }
}
