<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FurnitureServiceRequest extends FormRequest
{
    public function authorize(): bool
    {
        // Aquí podrías poner lógica de autorización según roles/permissions
        return true;
    }

    public function rules(): array
    {
        return [
            'user_id' => 'required',
            'customer_id' => 'required',
            'proforma_id'    => 'required|exists:proformas,id',
            'price'          => 'required|numeric|min:0',
            'responsible_id' => 'required|exists:users,id',
            'notes'          => 'nullable|string',
            'status'         => 'required|in:pendiente,en_proceso,completado',
        ];
    }

    public function messages(): array
    {
        return [
            'proforma_id.required'    => 'El pedido (proforma) es obligatorio.',
            'proforma_id.exists'      => 'El pedido seleccionado no existe.',

            'price.required'          => 'El precio es obligatorio.',
            'price.numeric'           => 'El precio debe ser un número.',

            'responsible_id.required' => 'El responsable es obligatorio.',
            'responsible_id.exists'   => 'El responsable seleccionado no existe.',

            'status.required'         => 'El estado es obligatorio.',
            'status.in'               => 'El estado debe ser: pendiente, en_proceso o completado.',
        ];
    }
}
