<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class MedicalConsultationRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true; // Cambia esto si usás políticas
    }

    public function rules(): array
    {
        return [
            'customer_id' => 'required|numeric',
            'patient_name'       => 'required|string|max:255',
            'age'                => 'required|integer|min:18|max:100',
            'right_esf'          => 'nullable|numeric',
            'right_cil'          => 'nullable|numeric',
            'right_eje'          => 'nullable|numeric',
            'right_add'          => 'nullable|numeric',
            'right_dist'         => 'nullable|numeric',
            'right_alt'          => 'nullable|numeric',
            'left_esf'           => 'nullable|numeric',
            'left_cil'           => 'nullable|numeric',
            'left_eje'           => 'nullable|numeric',
            'left_add'           => 'nullable|numeric',
            'left_dist'          => 'nullable|numeric',
            'left_alt'           => 'nullable|numeric',
            'crystal_type'       => 'nullable|string|min:5|max:255',
            'additional_notes'   => 'nullable|string|min:5|max:1000',
            'type'               => 'nullable|in:Invisible,Flat Top,Progresivo,Visión sencilla,Lentes de contacto',
            'price'           => 'nullable|numeric',
        ];
    }

    public function messages(): array
    {
        return [
            'patient_name.required' => 'El nombre del paciente es obligatorio.',
            'patient_name.string' => 'El nombre del paciente debe ser un texto.',
            'patient_name.max' => 'El nombre del paciente no puede tener más de 255 caracteres.',

            'age.required' => 'La edad es obligatoria.',
            'age.integer' => 'La edad debe ser un número entero.',
            'age.min' => 'La edad no puede ser menor que 18.',
            'age.max' => 'La edad no puede ser mayor a 150.',

            'right_esf.numeric' => 'El valor ESF del ojo derecho debe ser numérico.',
            'right_cil.numeric' => 'El valor CIL del ojo derecho debe ser numérico.',
            'right_eje.numeric' => 'El valor EJE del ojo derecho debe ser numérico.',
            'right_add.numeric' => 'El valor ADD del ojo derecho debe ser numérico.',
            'right_dist.numeric' => 'El valor DIST del ojo derecho debe ser numérico.',
            'right_alt.numeric' => 'El valor ALT del ojo derecho debe ser numérico.',

            'left_esf.numeric' => 'El valor ESF del ojo izquierdo debe ser numérico.',
            'left_cil.numeric' => 'El valor CIL del ojo izquierdo debe ser numérico.',
            'left_eje.numeric' => 'El valor EJE del ojo izquierdo debe ser numérico.',
            'left_add.numeric' => 'El valor ADD del ojo izquierdo debe ser numérico.',
            'left_dist.numeric' => 'El valor DIST del ojo izquierdo debe ser numérico.',
            'left_alt.numeric' => 'El valor ALT del ojo izquierdo debe ser numérico.',

            'crystal_type.string'     => 'El tipo de cristal debe ser un texto.',
            'crystal_type.min' => 'Ingrese mínimo 5 dígitos',
            'crystal_type.max' => 'Ingrese máximo 255 dígitos',

            'additional_notes.string' => 'Las notas adicionales deben ser un texto.',
            'additional_notes.min' => 'Ingrese mínimo 5 dígitos',
            'additional_notes.max' => 'Ingrese máximo 255 dígitos',

            'type.in' => 'El tipo debe ser "Invisible" o "Flat Top" o "Progresivo" o "Visión sencilla" o "Lentes de contacto"',

            'price.numeric' => 'El precio debe ser numérico.',
        ];
    }
}
