<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class OpenCashRegisterRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true; // Aquí puedes validar permisos con policies
    }

    public function rules(): array
    {
        return [
            'opening_amount' => 'required|numeric|min:0',
        ];
    }

    public function messages(): array
    {
        return [
            'opening_amount.required' => 'Debe ingresar un monto de apertura.',
            'opening_amount.numeric' => 'El monto de apertura debe ser numérico.',
            'opening_amount.min' => 'El monto de apertura no puede ser negativo.',
        ];
    }
}
