<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductTransferRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'reference' => 'nullable|string|max:120',
            'from_branch_id' => 'required|exists:branches,id',
            'to_branch_id' => 'required|exists:branches,id|different:from_branch_id',
            'user_id' => 'nullable|exists:users,id',
            'status' => 'nullable',
            'notes' => 'nullable|string|max:500',
            'details' => 'required|array|min:1',
            'details.*.productId' => 'required|exists:products,id',
            'details.*.variantId' => 'nullable',
            'details.*.quantity' => 'required|integer|min:1',
            'details.*.name' => 'required',
            'details.*.size' => 'nullable',
            'details.*.color' => 'nullable',
        ];
    }

    public function messages(): array
    {
        return [
            'from_branch_id.required' => 'La sucursal de origen es obligatoria.',
            'to_branch_id.required' => 'La sucursal de destino es obligatoria.',
            'to_branch_id.different' => 'La sucursal de destino debe ser diferente de la de origen.',
            'details.required' => 'Debes agregar al menos un producto al movimiento.',
        ];
    }
}
