<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PurchaseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'user_id' => 'nullable',
            'supplier_id' => 'required|exists:suppliers,id',
            'order_status' => 'nullable',
            'invoice_number' => 'nullable',

            'purchaseDetails' => 'required|array',
            'purchaseDetails.*.id' => 'nullable',
            'purchaseDetails.*.productId' => 'required|exists:products,id',
            'purchaseDetails.*.variantId' => 'nullable',
            'purchaseDetails.*.name' => 'required|string',
            'purchaseDetails.*.size' => 'nullable',
            'purchaseDetails.*.color' => 'nullable',
            'purchaseDetails.*.quantity' => 'required|integer|min:1',
            'purchaseDetails.*.purchase_price' => 'required|numeric|min:0',
            'purchaseDetails.*.price' => 'nullable|numeric|min:0',
        ];
    }

    public function messages(): array
    {
        return [
            'supplier_id.required' => 'Seleccione un proveedor',
            'supplier_id.exists' => 'El proveedor no existe',

            'purchaseDetails.required' => 'Agregue uno o varios productos',
            'purchaseDetails.array' => 'Los datos no son los correctos',

            'purchaseDetails.*.productId.required' => 'El producto es obligatorio.',
            'purchaseDetails.*.productId.exists' => 'El producto seleccionado no es válido.',
            
            'purchaseDetails.*.quantity.required' => 'La cantidad es obligatoria.',
            'purchaseDetails.*.quantity.integer' => 'La cantidad debe ser un número entero.',
            'purchaseDetails.*.quantity.min' => 'La cantidad debe ser al menos 1.',

            'purchaseDetails.*.purchase_price.required' => 'El precio es obligatorio.',
            'purchaseDetails.*.purchase_price.numeric' => 'El precio debe ser un número.',
            'purchaseDetails.*.purchase_price.min' => 'El precio no puede ser negativo.',

            'purchaseDetails.*.price.numeric' => 'El precio debe ser un número.',
            'purchaseDetails.*.price.min' => 'El precio no puede ser negativo.',
        ];
    }
}
