<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SalePaymentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'user_id' => 'nullable',
            'sale_id' => 'required|exists:sales,id',
            'amount' => 'required|numeric|min:0.01',
            'method' => 'required',
            'operation_number' => 'required|min:5|max:50',
        ];
    }

    public function messages()
    {
        return [
            'sale_id.required' => 'El id de la venta es requerido.',

            'amount.required' => 'El monto es requerido.',
            'amount.numeric' => 'Ingrese un valor numérico.',
            'amount.min' => 'Ingrese un valor mayor a 0.',

            'method.required' => 'Seleccione un método de pago.',

            'operation_number.required' => 'El monto es requerido.',
            'operation_number.min' => 'Ingrese mínimo 5 dígitos.',
            'operation_number.max' => 'Ingrese máximo 50 dígitos.',
        ];
    }
}
