<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SaleRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'user_id' => 'required',
            'branch_id' => 'required',
            'cash_register_id' => 'required',
            'customer_id' => 'required|exists:clients,id',
            'advance_payment' => 'nullable',
            'status' => 'required',

            // Validations for sale details
            'saleDetails' => 'required|array|min:1',
            'saleDetails.*.productId' => 'required|exists:products,id',
            'saleDetails.*.variantId' => 'nullable',
            'saleDetails.*.name' => 'required|string',
            'saleDetails.*.size' => 'nullable',
            'saleDetails.*.color' => 'nullable',
            'saleDetails.*.quantity' => 'required|integer|min:1',
            'saleDetails.*.price' => 'required|numeric|min:0',
        ];
    }

    public function messages()
    {
        return [
            'customer_id.required' => 'The customer is required.',
            'customer_id.exists' => 'The selected customer does not exist.',

            'saleDetails.required' => 'At least one product is required in the sale.',
            'saleDetails.array' => 'The sale details must be an array.',
            'saleDetails.min' => 'At least one product must be included in the sale.',

            'saleDetails.*.productId.required' => 'A product is required.',
            'saleDetails.*.productId.exists' => 'The selected product does not exist.',

            'saleDetails.*.quantity.required' => 'The quantity is required.',
            'saleDetails.*.quantity.integer' => 'The quantity must be an integer.',
            'saleDetails.*.quantity.min' => 'The quantity must be at least 1.',

            'saleDetails.*.price.required' => 'The price is required.',
            'saleDetails.*.price.numeric' => 'The price must be a valid number.',
            'saleDetails.*.price.min' => 'The price cannot be negative.',
        ];
    }
}
