<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StaffPaymentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'employee_id'      => 'required|exists:employees,id',
            'amount'           => 'required|numeric|min:0',
            'payment_date'     => 'required|date',
            'method'           => 'nullable|string|max:50',
            'operation_number' => 'nullable|string|max:100',
            'notes'            => 'nullable|string|max:500',
            'user_id' => 'required|exists:users,id',
        ];
    }

    public function messages(): array
    {
        return [
            'employee_id.required'  => 'Debe seleccionar un empleado.',
            'amount.required'       => 'Debe ingresar el monto del pago.',
            'payment_date.required' => 'Debe ingresar la fecha del pago.',
        ];
    }
}
