<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SupplierRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'user_id' => "nullable",
            'name' => 'required|string|min:6|max:50',
            'ruc' => 'required|string|min:11|max:11|unique:suppliers,ruc,' . $this->supplier,
            'contact_person' => 'required|string|min:5|max:60',
            'phone_number' => 'nullable|string|min:6|max:20',
            'address' => 'nullable|string|min:5|max:255',
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'El campo es obligatorio',
            'name.string' => 'Ingrese una cadena correcta',
            'name.min' => 'Ingrese mínimo 6 dígitos',
            'name.max' => 'Ingrese máximo 50 dígitos',

            'ruc.required' => 'El campo es obligatorio',
            'ruc.string' => 'Ingrese una cadena correcta',
            'ruc.min' => 'Ingrese mínimo 11 dígitos',
            'ruc.max' => 'Ingrese máximo 11 dígitos',
            'ruc.unique' => 'El ruc ya existe',
            
            'contact_person.required' => 'El campo es obligatorio',
            'contact_person.string' => 'Ingrese una cadena correcta',
            'contact_person.min' => 'Ingrese mínimo 5 dígitos',
            'contact_person.max' => 'Ingrese máximo 60 dígitos',

            'phone_number.string' => 'Ingrese una cadena correcta',
            'phone_number.min' => 'Ingrese mínimo 6 dígitos',
            'phone_number.max' => 'Ingrese máximo 20 dígitos',

            'address.string' => 'Ingrese una cadena correcta',
            'address.min' => 'Ingrese mínimo 5 dígitos',
            'address.max' => 'Ingrese máximo 255 dígitos',
        ];
    }
}
