<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateBranchRequest extends FormRequest
{
    /**
     * Determina si el usuario está autorizado a hacer esta solicitud.
     */
    public function authorize(): bool
    {
        return true; // Cambia esto si manejas permisos por usuario
    }

    /**
     * Reglas de validación.
     */
    public function rules(): array
    {
        return [
            'user_id' => "nullable",
            'name' => 'required|string|min:3|max:50|unique:branches,name,' . $this->id,
            'address' => 'required|string|min:5|max:150',
            'phone' => 'nullable|string|min:6|max:15',
            'status' => 'required|in:activo,inactivo',
        ];
    }

    /**
     * Personaliza los mensajes de error.
     */
    public function messages(): array
    {
        return [
            'name.required' => 'El nombre de la sucursal es obligatorio.',
            'name.unique' => 'El nombre de la sucursal ya existe.',
            'name.min' => 'El nombre debe tener mínimo 3 caracteres.',
            'name.max' => 'El nombre debe tener máximo 50 caracteres.',

            'address.required' => 'La dirección es obligatoria.',
            'address.min' => 'La dirección debe tener mínimo 5 caracteres.',
            'address.max' => 'La dirección debe tener máximo 150 caracteres.',

            'phone.min' => 'El teléfono debe tener mínimo 6 caracteres.',
            'phone.max' => 'El teléfono debe tener máximo 15 caracteres.',

            'status.required' => 'El estado es obligatorio.',
            'status.in' => 'El estado debe ser activo o inactivo.',
        ];
    }
}
