<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateBrandRequest extends FormRequest
{
    /**
     * Determina si el usuario está autorizado a hacer esta solicitud.
     */
    public function authorize(): bool
    {
        return true; // Aquí luego puedes controlar con permisos/roles
    }

    /**
     * Reglas de validación.
     */
    public function rules(): array
    {
        return [
            'user_id' => "nullable|exists:users,id",
            'name' => 'required|string|min:2|max:50|unique:brands,name,' . $this->id,
            'description' => 'nullable|string|min:0|max:150',
        ];
    }

    /**
     * Mensajes de error personalizados.
     */
    public function messages(): array
    {
        return [
            'name.required' => 'El nombre de la marca es obligatorio',
            'name.unique' => 'La marca ya existe',
            'name.min' => 'El nombre debe tener al menos 2 caracteres',
            'name.max' => 'El nombre debe tener máximo 50 caracteres',

            'description.min' => 'La descripción debe tener mínimo 0 caracteres',
            'description.max' => 'La descripción debe tener máximo 150 caracteres',
        ];
    }
}
