<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateCategoryRequest extends FormRequest
{
    /**
     * Determina si el usuario está autorizado a hacer esta solicitud.
     */
    public function authorize(): bool
    {
        return true; // Cambia esto según tus permisos
    }

    /**
     * Reglas de validación.
     */
    public function rules(): array
    {
        return [
            'user_id' => "nullable",
            'name' => 'required|string|min:5|max:50|unique:categories,name,'. $this->id,
            'description' => 'nullable|string|min:5|max:100|',
        ];
    }

    /**
     * Personaliza los mensajes de error.
     */
    public function messages(): array
    {
        return [
            'name.required' => 'El nombre es obligatorio',
            'name.unique' => 'El nombre ya existe',
            'name.min' => 'El nombre debe tener mínimo 5 dígitos',
            'name.max' => 'El nombre debe tener máximo 50 dígitos',

            'description.min' => 'La descripción debe tener mínimo 5 dígitos',
            'description.max' => 'La descripción debe tener máximo 100 dígitos',
        ];
    }
}
