<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateFurnitureServiceRequest extends FormRequest
{
    public function authorize(): bool
    {
        // Aquí podrías poner lógica de autorización según roles/permissions
        return true;
    }

    public function rules(): array
    {
        return [
            'tools_used' => 'required|string',
            'status' => 'required',
        ];
    }

    public function messages(): array
    {
        return [
            'tools_used.required'    => 'El campo es obligatorio.',
            'tools_used.string'      => 'Ingrese una o varias herramientas.',

            'status.required'    => 'El campo es obligatorio.',
        ];
    }
}
