<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateUserRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'branch_id' => 'required|exists:branches,id',
            'user_id' => "nullable",
            'name' => 'required|string|min:6|max:80',
            'roles' => 'required',
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'El campo es obligatorio',
            'name.string' => 'Ingrese una cadena correcta',
            'name.min' => 'Ingrese mínimo 6 dígitos',
            'name.max' => 'Ingrese máximo 80 dígitos',

            'roles.required' => 'Seleccione un rol',

            'branch_id.required' => 'Debe seleccionar una sucursal.',
            'branch_id.exists' => 'La sucursal seleccionada no es válida.',
        ];
    }
}
