<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserChangePasswordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'id' => 'required',
            'password' => 'required|string|min:8|max:15',
            'passwordConfirm' => 'required|string|min:8|max:15|same:password',
        ];
    }

    public function messages(): array
    {
        return [
            'password.required' => 'El campo es obligatorio',
            'password.string' => 'Ingrese una cadena correcta',
            'password.min' => 'Ingrese mínimo 8 dígitos',
            'password.max' => 'Ingrese máximo 15 dígitos',

            'passwordConfirm.required' => 'El campo es obligatorio',
            'passwordConfirm.string' => 'Ingrese una cadena correcta',
            'passwordConfirm.min' => 'Ingrese mínimo 8 dígitos',
            'passwordConfirm.max' => 'Ingrese máximo 15 dígitos',
            'passwordConfirm.same' => 'Confirme su contraseña',
        ];
    }
}
