<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BranchProductStock extends Model
{
    protected $table = 'branch_product_stock';

    protected $fillable = [ 
        'branch_id',
        'product_id',
        'product_variant_id',
        'stock',
    ];

    // =====================
    // Relaciones
    // =====================

    /**
     * Sucursal
     */
    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    /**
     * Producto sin variantes
     */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * Variante de producto
     */
    public function variant()
    {
        return $this->belongsTo(ProductVariant::class, 'product_variant_id', 'id');
    }

    public function proforma_item()
    {
        return $this->belongsTo(ProformaItem::class, 'product_id', 'id');
    }
}
