<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CashRegister extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'user_id_closed',
        'branch_id',
        'opening_amount',
        'closing_amount',
        'closing_balance',
        'opened_at',
        'closed_at',
        'status',
    ];

    protected $casts = [
        'opened_at' => 'datetime',
        'closed_at' => 'datetime',
    ];

    // Relación con usuario
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Relación con sucursal
    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    // Relación con pagos
    public function payments()
    {
        return $this->hasMany(SalePayment::class);
    }
}
