<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;

    protected $fillable = [
        'first_name',
        'last_name',
        'document_number',
        'position',
        'salary',
        'address',
        'phone',
        'user_id',
    ];

    /**
     * Relación: Un empleado fue registrado por un usuario.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Nombre completo del empleado (accesor).
     */
    public function getFullNameAttribute(): string
    {
        return "{$this->first_name} {$this->last_name}";
    }
}
