<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FurnitureService extends Model
{
    use HasFactory;

    protected $fillable = [
        'proforma_id',
        'customer_id',
        'user_id',
        'price',
        'tools_used',
        'responsible_id',
        'notes',
        'status',
    ];

    /**
     * Relación con la proforma (pedido).
     */
    public function proforma()
    {
        return $this->belongsTo(Proforma::class);
    }

    /**
     * Relación con el usuario responsable.
     */
    public function responsible()
    {
        return $this->belongsTo(User::class, 'responsible_id');
    }

    public function customer()
    {
        return $this->belongsTo(Client::class);
    }
}
