<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MedicalConsultation extends Model
{
    protected $fillable = [
        'customer_id',
        'invoice_number',
        'patient_name',
        'age',
        'consultation_date',
        'right_esf', 'right_cil', 'right_eje', 'right_add', 'right_dist', 'right_alt',
        'left_esf', 'left_cil', 'left_eje', 'left_add', 'left_dist', 'left_alt',
        'crystal_type', 'additional_notes', 'type', 'price'
    ];

    // Relación con el cliente
    public function customer()
    {
        return $this->belongsTo(Client::class);
    }
}
