<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'name', 'supplier_barcode', 'description', 'purchase_price', 'price', 'min_price', 'stock', 'min_stock', 'type', 'main_image', 'has_variants', 'brand_id', 'category_id'];

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function variants()
    {
        return $this->hasMany(ProductVariant::class);
    }

    public function images()
    {
        return $this->hasMany(ProductImage::class);
    }

    public function branchStocks()
    {
        return $this->hasMany(BranchProductStock::class, 'product_id');
    }

    public function sale_details()
    {
        return $this->hasMany(SaleDetail::class);
    }

    public function purchase_details()
    {
        return $this->hasMany(PurchaseDetail::class);
    }

    public function transfer_items()
    {
        return $this->hasMany(ProductTransferItem::class);
    }

    public function getFinalPriceAttribute()
    {
        if ($this->has_variants) {
            return null; // Se maneja desde `product_variants`
        }
        return $this->price;
    }

    public function getFinalStockAttribute()
    {
        if ($this->has_variants) {
            return null; // Se maneja desde `product_variants`
        }
        return $this->stock;
    }
}